clear
close all
clc

%indiceColonnaDI=3; %DIbefore
indiceColonnaDI=4; %DIafter

load('MDmorn_EEG_powerbands')
%    load('potenze_RS_buio2022_12_ICA.mat'])

p_val_th=0.05;
stile_elettrodi='pts';

nSogg=size(P_gamma,1);


for i=1:size(P_gamma,3)
    [rho_p_alfa(i),pval_p_alfa(i)]=corr(nanmean(P_alfa(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');
    [rho_p_teta(i),pval_p_teta(i)]=corr(nanmean(P_teta(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');
    [rho_p_beta1(i),pval_p_beta1(i)]=corr(nanmean(P_beta1(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');
    [rho_p_beta2(i),pval_p_beta2(i)]=corr(nanmean(P_beta2(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');      %  [rho(i,k),pval(i,k)]=corr(F_alfa(:,k,i),psicometriche(:,4),'type','Spearman', 'rows','pairwise');
    [rho_p_gamma(i),pval_p_gamma(i)]=corr(nanmean(P_gamma(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');
    [rho_p_tetabeta(i),pval(i)]=corr(nanmean(P_teta(:,:,i)./P_beta(:,:,i),2),(psicometriche(:,indiceColonnaDI)),'type','Spearman', 'rows','pairwise');
end

%%%%%%
figure(101),subplot(1,1,1),AP_topoplot(rho_p_alfa,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval_p_alfa<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval_p_alfa<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_alfa','-dpng','-r300');

%%%%%%
figure(105),subplot(1,1,1),AP_topoplot(rho_p_teta,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval_p_teta<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval_p_teta<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_teta','-dpng','-r300');


%%%%%%
figure(107),subplot(1,1,1),AP_topoplot(rho_p_beta1,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval_p_beta1<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval_p_beta1<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_beta1','-dpng','-r300');

%%%%%%
figure(108),subplot(1,1,1),AP_topoplot(rho_p_beta2,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval_p_beta2<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval_p_beta2<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_beta2','-dpng','-r300');

%%%%%%
figure(1010),subplot(1,1,1),AP_topoplot(rho_p_gamma,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval_p_gamma<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval_p_gamma<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_gamma','-dpng','-r300');

%%%%%%
figure(1011),subplot(1,1,1),AP_topoplot(rho_p_tetabeta,chanlocs,'maplimits',[-1 1],'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5);%title(['DI'])
colorbar
if  sum(pval<p_val_th)>3
    hold on;AP_topoplot([],chanlocs(pval<p_val_th),'emarker',{'.','k',16,1},'hcolor','none','intrad',.5);
end
%print('rho_p_tetabeta','-dpng','-r300');

electrodeCoordinates=chanlocs;
save('correlationMap_DIafter_vs_p_bands_wake','electrodeCoordinates','rho_p_teta','rho_p_alfa','rho_p_beta1','rho_p_beta2','rho_p_gamma')

